﻿//////////////////////////////////////////////
// ComboBox.h
//
//////////////////////////////////////////////

/// Defines / macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkWinUi
#include "Component.h"

#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standard
#include <functional>
#include <unordered_map>

/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT ComboBox : public Component
	{
		public :

			// Entry possible
			class DLL_WINUI_EXPORT Entry final
			{
				public :

					// Constructor, destructor
					Entry () noexcept ;
					~Entry () ;

					// Getters
					nkMemory::StringView getLabel () const ;
					void* getAttachedData () const ;

					// Setters
					void setLabel (nkMemory::StringView label) ;
					void setAttachedData (void* data) ;

				private :

					// Attributes
					nkMemory::String _label ;
					void* _attachedData ;
			} ;
		
		public :
		
			// Constructeur, destructeur
			ComboBox (System* system) noexcept ;
			ComboBox (const ComboBox&) = delete ;
			virtual ~ComboBox () ;

			// Getters
			std::function<void (ComboBox*)> getSelectionCallback () const ;
			Entry* getEntryPerLabel (nkMemory::StringView label) const ;
			Entry* getEntryPerData (void* data) const ;
			virtual Entry* getCurrentSelection () const ;

			// Setters
			void setSelectionCallback (std::function<void (ComboBox*)> value) ;
			void setSelectedEntryPerLabel (nkMemory::StringView label) ;
			void setSelectedEntryPerData (void* data) ;
			virtual void setSelectedEntry (Entry* selected) ;

			// Entries
			virtual Entry* insertEntry (nkMemory::StringView label, void* data) ;
			void setEntryData (nkMemory::StringView label, void* newData) ;
			virtual void* deleteEntry (nkMemory::StringView label) ;
			virtual void clearEntries () ;

			// Export / import
			virtual void exportIntrospection (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

			// Operators
			ComboBox& operator= (const ComboBox&) = delete ;

		public :

			// Statics
			static nkMemory::UniquePtr<ComboBox> create (System* system = nullptr) ;

		protected :
		
			// Attributes
			// Entries
			std::unordered_map<std::string, nkMemory::UniquePtr<Entry>> _memory ;
			std::unordered_map<void*, Entry*> _memoryPerData ;

			// Entrée sélectionnée
			Entry* _selectedEntry ;

			// Callbacks
			std::function<void (ComboBox*)> _selectionCallback ;
	} ;
}